#ifndef __CClassWriter__
#define __CClassWriter__

#include <ECore.h>

namespace Exponent
{
	namespace ClassWrite
	{

		/**
		 * @class CClassWriter CClassWriter.hpp
		 * @brief Writes Exponent format classes
		 *
		 * @date 08/12/2006
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 * @version 1.0.1 Fixed const correctness for the equality / inequality operators
		 * @version 1.0.2 Added inplace get as string function
		 *
		 * @note All contents of this source code are copyright 2007 Exp Digital Uk.\n
		 * This file forms part of the example projects for the Infinity API.\n
		 * You may not redistribute either the source code or the compiled binary.\n
		 * The Infinity API is covered by a fair use licence which you should have recieved with this\n
		 * file. If you didnt receieve the licence, please contact us via http://www.expdigital.co.uk
		 *
		 * $Id: CClassWriter.hpp,v 1.3 2007/02/11 02:20:05 paul Exp $
		 */
		class CClassWriter : public CCountedObject
		{
			/** @cond */
			EXPONENT_CLASS_DECLARATION;
			/** @endcond */

//	===========================================================================

		public:

//	===========================================================================

			/**
			 * @enum EClassType
			 * @brief Enumeration of the type of file we are building
			 */
			enum EClassType
			{
				e_class = 0,							/**< Its a class */
				e_interface,							/**< Its an interface */
				e_struct,								/**< Its a structure */
				e_template,								/**< Its a template file */
			};

			/**
			 * @enum EParentType
			 * @brief The type of parent object
			 */
			enum EParentType
			{
				e_nothing = 0,							/**< No parent */
				e_iCountedObject,						/**< ICountedObject interface parent */
				e_cCountedObject,						/**< CCountedObject parent */
				e_control,								/**< CControl is the parent */
				e_controlPanel,							/**< CControlPanel is the parent */
			};

//	===========================================================================

			/**
			 * Construction
			 * @param name The name of the object to write, should not include the capitalised type at the beggining
			 * @param type The type of class to write
			 * @param parent The parent class of the class to write
			 * @param namespaces The namespace that the class to write is contained within
			 * @param outputFolder The location to write the output files to
			 */
			CClassWriter(const CString &name, const EClassType type, const EParentType parent, TStringCountedPointerArray &namespaces, const CSystemString &outputFolder);

			/**
			 * Destruction
			 */
			virtual ~CClassWriter();

//	===========================================================================

		protected:

//	===========================================================================

			/**
			 * Write the header file
			 */
			void writeHeaderFile();

			/**
			 * @brief Write some tabs
			 */
			void writeTabs();

			/**
			 * Write the header guard
			 */
			void writeHeaderGuard();

			/**
			 * Write closing guard
			 */
			void writeClosingGuard();

			/**
			 * Write the include files
			 */
			void writeIncludes();

			/**
			 * Write doxygen main comment
			 */
			void writeDoxygenMainComment();

			/**
			 * Write class declaration
			 */
			void writeClassDeclaration();

			/**
			 * Write public opener
			 */
			void writePublicOpener();

			/**
			 * Write protected opener
			 */
			void writeProtectedOpener();

			/**
			 * Write the constructor
			 */
			void writeConstructor();

			/**
			 * Write the destructor
			 */
			void writeDestructor();

			/**
			 * Write counted object stuff
			 */
			void writeCountedObjectFunctions();

			/**
			 * Write the control functions
			 */
			void writeControlFunctions();

			/**
			 * Write the namespace opening
			 */
			void writeNamespaceOpening();

			/**
			 * Write the class closing
			 */
			void writeNamespaceClosing();

			/**
			 * Write template extras
			 */
			void writeTemplateExtras();

			/**
			 * Write the implementation file
			 */
			void writeImplementationFile();

//	===========================================================================

			long m_currentTabIndent;					/**< Current tab level */
			CTextStream m_stream;						/**< The stream that we are writing to */

			EClassType m_classType;						/**< The type of class that we are writing */
			EParentType m_parentType;					/**< Type of the parent */

			TStringCountedPointerArray m_namespace;		/**< the namespaces */
			CString m_name;								/**< Name of the class we are writing */
			CSystemString m_outputPath;					/**< The path to write the files to */
		};
	}
}
#endif	// End of CClassWriter.hpp